#!/bin/bash

# This file is shipped with the archive in which we publish object files
# from a build with statically linked binaries. It can be used to link
# the shipped object files with an external version of glibc. It produces
# the following static executables:
#  - arangod
#  - arangobench
#  - arangodump
#  - arangorestore
#  - arangosh
#  - arangovpack
#  - arangoexport
#  - arangoimport
#  - arangobackup

# Use Ubuntu 24.04 (with glibc 2.39 or later) and install the following
# packages:
#   apt install build-essential clang-16 lld-16 liburing-dev

# Execute in the directory in which you extracted the object archive!

cd build

echo arangod
cd arangod
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangod.dir/RestServer/arangod.cpp.o -o ../bin/arangod -L../3rdParty/jemalloc/lib -L../3rdParty/zlib/zlib-1.2.13 -L../3rdParty/v8-build/v8/x64.release/gypfiles -L../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../3rdParty/rocksdb -L../bin ../bin/libarangoserver.a ../bin/libarango_iresearch.a ../3rdParty/jemalloc/lib/libjemalloc.a ../bin/libarango_agency.a ../bin/libarango_aql.a ../bin/libarango_cluster_engine.a ../bin/libarango_cluster_methods.a ../bin/libarango_common_rest_handler.a ../bin/libarango_graph.a ../bin/libarango_indexes.a ../bin/libarango_metrics.a ../bin/libarango_network.a ../bin/libarango_replication.a ../bin/libarango_storage_engine.a ../bin/libarango_utils.a ../bin/libarango_vocbase.a ../bin/libarango_v8server.a ../bin/libarango_replication2.a ../bin/libarango_rocksdb.a ../bin/libarango_vocbase_api.a ../bin/libarango_storage_engine_common.a ../bin/libarangoserver.a ../bin/libarango_iresearch.a ../bin/libarango_agency.a ../bin/libarango_aql.a ../bin/libarango_cluster_engine.a ../bin/libarango_cluster_methods.a ../bin/libarango_common_rest_handler.a ../bin/libarango_graph.a ../bin/libarango_indexes.a ../bin/libarango_metrics.a ../bin/libarango_network.a ../bin/libarango_replication.a ../bin/libarango_storage_engine.a ../bin/libarango_utils.a ../bin/libarango_vocbase.a ../bin/libarango_v8server.a ../bin/libarango_replication2.a ../bin/libarango_rocksdb.a ../bin/libarango_vocbase_api.a ../bin/libarango_storage_engine_common.a ../bin/libboost_thread.a ../bin/libiresearch-s.a ../bin/libanalyzer-delimiter-s.a ../bin/libanalyzer-multi-delimiter-s.a ../bin/libanalyzer-ngram-s.a ../bin/libanalyzer-text-s.a ../bin/libanalyzer-norm-s.a ../bin/libanalyzer-minhash-s.a ../bin/libanalyzer-collation-s.a ../bin/libanalyzer-stem-s.a ../bin/libanalyzer-stopwords-s.a ../bin/libanalyzer-pipeline-s.a ../bin/libanalyzer-segmentation-s.a ../bin/libanalyzer-classification-s.a ../bin/libanalyzer-nearest-neighbors-s.a ../bin/libformat-1_0-s.a ../bin/libscorer-bm25-s.a ../bin/libscorer-tfidf-s.a ../bin/libiresearch-s.a ../bin/libanalyzer-delimiter-s.a ../bin/libanalyzer-multi-delimiter-s.a ../bin/libanalyzer-ngram-s.a ../bin/libanalyzer-text-s.a ../bin/libanalyzer-norm-s.a ../bin/libanalyzer-minhash-s.a ../bin/libanalyzer-collation-s.a ../bin/libanalyzer-stem-s.a ../bin/libanalyzer-stopwords-s.a ../bin/libanalyzer-pipeline-s.a ../bin/libanalyzer-segmentation-s.a ../bin/libanalyzer-classification-s.a ../bin/libanalyzer-nearest-neighbors-s.a ../bin/libformat-1_0-s.a ../bin/libscorer-bm25-s.a ../bin/libscorer-tfidf-s.a ../bin/libsimdcomp-static.a -std=c99 -fPIC -Wextra -pedantic -Wshadow -O3 -g ../bin/libstemmer-static.a ../bin/libtext.a ../bin/libfasttext.a ../bin/libarango_v8.a ../bin/libarango_v8_no_deadline.a ../bin/libarango_replication2_pure.a ../bin/libarango_geo.a ../bin/libarango_health.a ../bin/libarango_cache.a ../bin/libarango_restart_action.a ../bin/libarango_zkd.a ../bin/librocksdb.a /usr/lib/x86_64-linux-gnu/liburing.a ../bin/libarango_rclone.a ../bin/libarango.a ../bin/libs2.a ../libssl.a ../libcrypto.a ../bin/libabsl_str_format_internal.a ../bin/libfuerte.a ../bin/libllhttp.a ../bin/libnghttp2.a ../bin/liblz4.a ../bin/libarango_crashhandler.a ../bin/libarango_build_id.a ../bin/liblinenoise-ng.a ../bin/libzlibstatic.a -latomic -lresolv -lrt -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot -licui18n -licuucx -licustubdata -ldl -ljemalloc ../bin/libarango_lightweight.a ../bin/libarango_futures.a ../bin/libarango_assertions.a ../bin/libboost_system.a ../bin/libabsl_cord.a ../bin/libabsl_cordz_info.a ../bin/libabsl_cord_internal.a ../bin/libabsl_cordz_functions.a ../bin/libabsl_cordz_handle.a ../bin/libabsl_crc_cord_state.a ../bin/libabsl_crc32c.a ../bin/libabsl_crc_internal.a ../bin/libabsl_crc_cpu_detect.a ../bin/libabsl_raw_hash_set.a ../bin/libabsl_hash.a ../bin/libabsl_city.a ../bin/libabsl_bad_variant_access.a ../bin/libabsl_low_level_hash.a ../bin/libabsl_bad_optional_access.a ../bin/libabsl_hashtablez_sampler.a ../bin/libabsl_exponential_biased.a ../bin/libarango_static_strings.a ../bin/libabsl_synchronization.a ../bin/libabsl_graphcycles_internal.a ../bin/libabsl_kernel_timeout_internal.a ../bin/libabsl_stacktrace.a ../bin/libabsl_symbolize.a ../bin/libabsl_malloc_internal.a ../bin/libabsl_debugging_internal.a ../bin/libabsl_demangle_internal.a ../bin/libabsl_time.a ../bin/libabsl_strings.a ../bin/libabsl_int128.a ../bin/libabsl_throw_delegate.a ../bin/libabsl_strings_internal.a ../bin/libabsl_base.a ../bin/libabsl_spinlock_wait.a -lrt ../bin/libabsl_raw_logging_internal.a ../bin/libabsl_log_severity.a ../bin/libabsl_civil_time.a ../bin/libabsl_time_zone.a ../bin/libsnappy.a ../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../bin/libfmt.a ../bin/libarango-validation.a ../bin/libvelocypack.a
cd ..

echo arangobench
cd client-tools/Benchmark
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangobench.dir/arangobench.cpp.o CMakeFiles/arangobench.dir/BenchFeature.cpp.o CMakeFiles/arangobench.dir/BenchmarkOperation.cpp.o CMakeFiles/arangobench.dir/testcases/helpers.cpp.o -o ../../bin/arangobench -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

echo arangodump
cd client-tools/Dump
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangodump.dir/DumpFeature.cpp.o CMakeFiles/arangodump.dir/arangodump.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/AttributeMaskingEE.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/CreditCardMask.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/DateMask.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/DecimalMask.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/EmailMask.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/IntegerMask.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/XifyFront.cpp.o CMakeFiles/arangodump.dir/__/__/enterprise/Enterprise/Maskings/ZipMask.cpp.o -o ../../bin/arangodump -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

echo arangorestore
cd client-tools/Restore
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangorestore.dir/arangorestore.cpp.o -o ../../bin/arangorestore -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango_restore.a ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

echo arangosh
cd client-tools/Shell
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangosh.dir/ShellFeature.cpp.o CMakeFiles/arangosh.dir/TelemetricsHandler.cpp.o CMakeFiles/arangosh.dir/V8ClientConnection.cpp.o CMakeFiles/arangosh.dir/V8ShellFeature.cpp.o CMakeFiles/arangosh.dir/ProcessMonitoringFeature.cpp.o CMakeFiles/arangosh.dir/arangosh.cpp.o "CMakeFiles/arangosh.dir/v8-deadline.cpp.o" ../Import/CMakeFiles/arangoimport_utils.dir/AutoTuneThread.cpp.o ../Import/CMakeFiles/arangoimport_utils.dir/ImportHelper.cpp.o ../Import/CMakeFiles/arangoimport_utils.dir/SenderThread.cpp.o -o ../../bin/arangosh -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libarango_v8.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfuerte.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libfuerte.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a
cd ../..

echo arangovpack
cd client-tools/VPack
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangovpack.dir/VPackFeature.cpp.o CMakeFiles/arangovpack.dir/arangovpack.cpp.o -o ../../bin/arangovpack -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

echo arangobackup
cd client-tools/Backup
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangobackup.dir/BackupFeature.cpp.o CMakeFiles/arangobackup.dir/arangobackup.cpp.o -o ../../bin/arangobackup -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libfuerte.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

echo arangoexport
cd client-tools/Export
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangoexport.dir/ExportFeature.cpp.o CMakeFiles/arangoexport.dir/arangoexport.cpp.o -o ../../bin/arangoexport -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

echo arangoimport
cd client-tools/Import
clang++-16 -Wall -Wextra -Wno-unused-parameter -Wno-deprecated-declarations -mfxsr -mmmx -msse -msse2 -mcx16 -msahf -mpopcnt -msse3 -msse4.1 -msse4.2 -mssse3 -mpclmul -mavx -mxsave -fno-stack-protector -Wsuggest-override -Wnon-virtual-dtor -g -gz -O3 -fno-omit-frame-pointer -fstandalone-debug -Wl,--build-id=sha1 -fno-stack-protector -fuse-ld=lld -static ../../../lib/BuildId/BuildId.ld -Wl,--build-id=sha1 CMakeFiles/arangoimport.dir/ImportFeature.cpp.o CMakeFiles/arangoimport.dir/arangoimport.cpp.o CMakeFiles/arangoimport_utils.dir/AutoTuneThread.cpp.o CMakeFiles/arangoimport_utils.dir/ImportHelper.cpp.o CMakeFiles/arangoimport_utils.dir/SenderThread.cpp.o -o ../../bin/arangoimport -L../../3rdParty/jemalloc/lib -L../../3rdParty/zlib/zlib-1.2.13 -L../../3rdParty/v8-build/v8/x64.release/gypfiles -L../../3rdParty/v8-build/v8/x64.release/obj.target/third_party/icu -L../../3rdParty/rocksdb -L../../bin ../../bin/libarango.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -ldl -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libboost_system.a ../../bin/libarango_shell.a ../../bin/libclienttools_utils.a ../../bin/libarango.a ../../bin/libs2.a ../../bin/libabsl_str_format_internal.a ../../bin/libarango_crashhandler.a ../../bin/libarango_build_id.a ../../bin/liblinenoise-ng.a ../../bin/libarango_lightweight.a ../../bin/libarango_futures.a ../../bin/libarango_static_strings.a ../../bin/libabsl_cord.a ../../bin/libabsl_cordz_info.a ../../bin/libabsl_cord_internal.a ../../bin/libabsl_cordz_functions.a ../../bin/libabsl_cordz_handle.a ../../bin/libabsl_crc_cord_state.a ../../bin/libabsl_crc32c.a ../../bin/libabsl_crc_internal.a ../../bin/libabsl_crc_cpu_detect.a ../../bin/libabsl_raw_hash_set.a ../../bin/libabsl_hash.a ../../bin/libabsl_city.a ../../bin/libabsl_bad_variant_access.a ../../bin/libabsl_low_level_hash.a ../../bin/libabsl_bad_optional_access.a ../../bin/libabsl_hashtablez_sampler.a ../../bin/libabsl_exponential_biased.a ../../bin/libabsl_synchronization.a ../../bin/libabsl_graphcycles_internal.a ../../bin/libabsl_kernel_timeout_internal.a ../../bin/libabsl_stacktrace.a ../../bin/libabsl_symbolize.a ../../bin/libabsl_malloc_internal.a ../../bin/libabsl_debugging_internal.a ../../bin/libabsl_demangle_internal.a ../../bin/libabsl_time.a ../../bin/libabsl_civil_time.a ../../bin/libabsl_time_zone.a ../../bin/libarango_assertions.a -ltorque_base -lv8_base_without_compiler -lv8_compiler -lv8_init -lv8_initializers -lv8_turboshaft -lv8_libbase -lv8_libplatform -lv8_snapshot ../../bin/libfmt.a ../../bin/libsnappy.a ../../bin/liblz4.a ../../3rdParty/libunwind/v1.7.2/src/.libs/libunwind.a ../../bin/libzlibstatic.a -licui18n -licuucx -licustubdata ../../libssl.a ../../libcrypto.a -latomic -lresolv -lrt -ljemalloc -ldl ../../bin/libfuerte.a ../../bin/libboost_system.a ../../bin/libvelocypack.a ../../bin/libabsl_strings.a ../../bin/libabsl_int128.a ../../bin/libabsl_strings_internal.a ../../bin/libabsl_base.a ../../bin/libabsl_spinlock_wait.a -lrt ../../bin/libabsl_throw_delegate.a ../../bin/libabsl_raw_logging_internal.a ../../bin/libabsl_log_severity.a ../../bin/libnghttp2.a ../../bin/libllhttp.a
cd ../..

