- [Other Licenses](#other-licenses)
  * [C/C++ Libraries](#cc-libraries)
  * [Libraries used by iresearch](#libraries-used-by-iresearch)
  * [Programs](#programs)
  * [Data files](#data-files)
  * [JavaScript](#javascript)
    + [Node core modules](#node-core-modules)
    + [Bundled NPM modules](#bundled-npm-modules)
    + [Backend libraries](#backend-libraries)
    + [Frontend libraries](#frontend-libraries)

# Other Licenses

## C/C++ Libraries

### Abseil - C++ Common Libraries

* Name: abseil-cpp
* Version: 13708db87b1ab69f4f2b3214f3f51e986546f282
* Date: 2022-11-22
* Project Home: https://abseil.io
* License: https://raw.githubusercontent.com/abseil/abseil-cpp/master/LICENSE
* License Name: Apache License 2.0
* License Id: Apache-2.0

### Boost

* Name: Boost
* Version: 1.78.0
* Date: 2021-12-08 03:45:00
* Project Home: http://www.boost.org/
* License: http://www.boost.org/LICENSE_1_0.txt
* License Name: Boost Software License 1.0
* License Id: BSL-1.0

### cmdline

* Name: cmdline
* Version: a68095a
* Date: 2012-10-22 10:23:16Z
* Project Home: https://github.com/tanakh/cmdline
* License: https://raw.githubusercontent.com/tanakh/cmdline/master/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

### CreditCardGenerator

_Enterprise Edition only_

* Name: CreditCardGenerator
* Version: (none)
* Date: 2016-06-21 21:40:21Z
* Project Home: https://github.com/stormdark/CreditCardGenerator
* License: https://raw.githubusercontent.com/stormdark/CreditCardGenerator/master/LICENSE
* License Name: MIT License
* License Id: MIT

### date

* Name: date
* Version: 3.0.0
* Date: 2020-06-03
* Project Home: https://github.com/HowardHinnant/date
* License: https://raw.githubusercontent.com/HowardHinnant/date/master/LICENSE.txt
* License Name: MIT License
* License Id: MIT

### faiss

* Name: faiss
* Version: 1.9.0
* Date: 2024-10-04
* Project Home:https://github.com/facebookresearch/faiss/
* License: https://github.com/facebookresearch/faiss/blob/main/LICENSE 
* License Name: MIT License
* License Id: MIT

### fasthash

* Name: fasthash
* Version: 1.0
* Date: 2012-11-02
* Project Home: https://code.google.com/p/fast-hash/
* License: https://raw.githubusercontent.com/arangodb/arangodb/devel/lib/Basics/fasthash.cpp
* License Name: MIT License
* License Id: MIT

### fakeit

* Name: fakeit
* Version: 2.0.3
* Date: 2017-02-28 13:11:35Z & 2018-08-17 00:22:33Z
* Project Home: https://github.com/eranpeer/FakeIt
* License: https://raw.githubusercontent.com/eranpeer/FakeIt/master/LICENSE
* License Name: MIT License
* License Id: MIT

### fastvalidate-utf8

* Name: fastvalidate-utf8
* Version: (none)
* Date: 2017-02-28 13:11:35Z 
* Project Home: https://github.com/lemire/fastvalidate-utf-8
* License: https://raw.githubusercontent.com/lemire/fastvalidate-utf-8/master/LICENSE-APACHE
* License Name: Apache License 2.0
* License Id: Apache-2.0

### fpconv_dtoa

* Name: fpconv
* Version: (none)
* Date: 2013-10-15 03:33:30Z
* Project Home: https://github.com/night-shift/fpconv/
* License: https://raw.githubusercontent.com/night-shift/fpconv/master/license
* License Name: MIT License
* License Id: MIT

### function2

* Name: function2
* Version: 4.0.0
* Date: 2019-01-04 11:55:29Z
* Project Home: https://github.com/Naios/function2
* License: https://raw.githubusercontent.com/Naios/function2/master/LICENSE.txt
* License Name: Boost Software License 1.0
* License Id: BSL-1.0

### GeographicLib

* Name: GeographicLib
* Version: 1.49
* Date: 2017-10-05 01:36:00Z
* Project Home: https://geographiclib.sourceforge.io/
* License: https://geographiclib.sourceforge.io/html/LICENSE.txt
* License Name: MIT License
* License Id: MIT

#### glibc

* Name: glibc
* Version: 2.39.0
* Date: 2024-01-31
* Project Home: https://www.gnu.org/software/libc
* License: https://www.gnu.org/licenses/lgpl-3.0.html
* License Name: GNU Lesser General Public License
* License Id: LGPL-3.0

### Google V8

* Name: V8
* Version: 12.1.165
* Date: 2023-11-20 02:40:45 -0800
* Project Home: https://github.com/v8/v8
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/LICENSE.v8
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### colorama

* Name: colorama
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/tree/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/colorama
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### cpu_features

* Name: cpu_features
* Version: 0.8.0
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/tree/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/cpu_features
* License Name: Apache License 2.0
* License Id: Apache-2.0

#### FDLIBM

* Name: FDLIBM
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/LICENSE.fdlibm
* License Comment: free as-is license (like ISC without liability clauses)

#### glibc mathematical functions

* Name: glibc
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/glibc/LICENSE
* License Name: GNU Lesser General Public License
* License Id: LGPL-2.1-only

#### Google Benchmark

* Name: Google benchmark
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/tree/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/google_benchmark
* License Name: Apache License 2.0
* License Id: Apache-2.0

#### googletest

* Name: googletest
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/tree/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/googletest
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### gyp

* Name: gyp
* Version: 0.16.1
* Date: 2023-10-25 08:29:23 +0200
* Project Home: https://github.com/nodejs/gyp-next
* License: https://github.com/arangodb/arangodb/blob/devel/3rdParty/v8-build/gyp/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### ICU

* Name: ICU (International Components for Unicode)
* Version: 73.1
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/icu/LICENSE
* License Name: ICU license
* License Comment: BSD-3-Clause + third-party license

#### Inspector Protocol

* Name: Chromium inspector (devtools) protocol
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/inspector_protocol/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### Jinja2

* Name: Jinja2 Python Template Engine
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/jinja2/LICENSE.rst
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### jsoncpp

* Name: jsoncpp JSON parser and builder
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/jsoncpp/LICENSE
* License Name: MIT License
* License Id: MIT

#### markupsafe

* Name: MarkupSafe Python Safe String Class
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/markupsafe/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### Strongtalk

* Name: Strongtalk
* Version: (bundled with V8)
* Date: (bundled with V8)
* Project Home: https://github.com/talksmall/Strongtalk
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/LICENSE.strongtalk
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### V8 builtins

* Name: V8 builtins
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/v8/builtins/LICENSE
* License Name: Python Software Foundation License Version 2
* License Id: Python-2.0

#### wasm-c-api

* Name: Wasm C/C++ API
* Version: (see V8)
* Date: (see V8)
* Project Home: (bundled with V8)
* License: https://github.com/arangodb/v8/blob/980b6da33f7275a2ef369e83299163f6446dd81f/third_party/wasm-api/LICENSE
* License Name: Apache License 2.0
* License Id: Apache-2.0

### wcwidth

* Name: wcwidth
* Version: commit 911263c514237997c9c590517672c6ea729388dc
* Date: 2022-12-16T06:51:44+0000
* Project Home: https://github.com/termux/wcwidth
* License: https://github.com/termux/wcwidth/blob/master/LICENSE.txt
* License Name: MIT License
* License Id: MIT

### Google Test

* Name: Google Test (gtest)
* Version: 1.12.1
* Date: 2022-06-30 10:14:00Z
* Project Home: https://github.com/google/googletest
* License: https://raw.githubusercontent.com/google/googletest/release-1.12.1/LICENSE 
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

### immer

* Name: immer
* Version: 0.8.0
* Date: 2022-12-06 11:30 UTC
* Project Home: https://github.com/arximboldi/immer
* License: https://github.com/arximboldi/immer/blob/v0.8.0/LICENSE
* License Name: Boost Software License 1.0

### jemalloc

* Name: jemalloc
* Version: 5.3.0, commit e4817c8d89a2a413e835c4adeab5c5c4412f9235
* Date: 2023-10-24 13:51:14 -0700
* Project Home: https://github.com/jemalloc/jemalloc
* License: https://raw.githubusercontent.com/jemalloc/jemalloc/dev/COPYING
* License Comment: free as-is license

  The generated files config.guess and config.sub have the explicit
  exception from the GPL license:

      As a special exception to the GNU General Public License, if you
      distribute this file as part of a program that contains a
      configuration script generated by Autoconf, you may include it under
      the same distribution terms that you use for the rest of that
      program.  This Exception is an additional permission under section 7
      of the GNU General Public License, version 3 ("GPLv3").

### libunwind

* Name: libunwind
* Version: 1.7.2
* Date: 2023-07-29 11:04:36 -0400
* Project Home: https://github.com/libunwind/libunwind
* License: https://raw.githubusercontent.com/libunwind/libunwind/master/LICENSE
* License Name: MIT License
* License Id: MIT

### linenoise-ng

* Name: linenoise-ng
* Version: 1.0.1
* Date: 2017-03-06 16:01:33Z
* GitHub: https://github.com/arangodb/linenoise-ng
* License: https://raw.githubusercontent.com/arangodb/linenoise-ng/master/LICENSE
* License Name: BSD 2-clause "Simplified" License
* License Id: BSD-2-Clause

### llhttp

* Name: llhttp
* Version: 6.0.4
* Date: 2021-06-26 22:27:35 -0700
* Project Home: https://github.com/nodejs/llhttp
* License: https://raw.githubusercontent.com/nodejs/llhttp/main/LICENSE-MIT
* License Name: MIT License
* License Id: MIT

### nghttp2

* Name: nghttp2
* Version: 1.61.0
* Date: 2024-04-04 17:16:56 +09:00
* GitHub: https://github.com/nghttp2/nghttp2
* License: https://raw.githubusercontent.com/nghttp2/nghttp2/master/COPYING
* License Name: MIT License
* License Id: MIT

### OpenSSL

* Name: OpenSSL
* Version: 1.1.1
* Date: 2021-08-24
* License: https://spdx.org/licenses/OpenSSL.html
* License Name: Apache Style License
* License Id: OpenSSL

### RocksDB

* Name: RocksDB
* Version: 9.5, commit 15d9988ab219a8a7bf38ef42d840f89ff1232be7
* Date: 2024-07-22 13:15:09 -0700
* GitHub: https://github.com/arangodb/rocksdb
* License: https://github.com/arangodb/rocksdb/blob/main/README.md
* License Name: Apache License 2.0
* License Id: Apache-2.0

### S2 Geometry Library

* Name: s2geometry
* Version: ce14f45ae0b6c28e3f47cbcf6646d988d41046b5
* Date: 2023-01-04
* Project Home: https://s2geometry.io/
* License: https://raw.githubusercontent.com/arangodb/arangodb/devel/3rdParty/s2geometry/dfefe0c/LICENSE
* License Name: Apache License 2.0
* License Id: Apache-2.0

### short_alloc

* Name: short_alloc
* Version: (none)
* Date: 2016-02-04 22:56:08Z
* Project Home: https://howardhinnant.github.io/stack_alloc.html
* License: https://howardhinnant.github.io/short_alloc.h
* License Name: MIT License
* License Id: MIT

### snappy

* Name: snappy
* Version: 1.2.2
* Date: 2021-05-04 22:28:33Z
* Project Home: https://github.com/google/snappy
* License: https://raw.githubusercontent.com/google/snappy/master/COPYING
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

### taocpp::json

* Name: taoJSON
* Version: (none)
* Date: 2020-03-14 19:09:08Z
* Project Home: https://github.com/taocpp/json
* License: https://raw.githubusercontent.com/taocpp/json/master/LICENSE
* License Name: MIT License
* License Id: MIT

### wyhash

* Name: wyhash
* Version: commit 896d7c57f68d96938f718c0695c44866d14b48d6
* Date: 2021-04-02 20:34:24 +08:00
* GitHub: https://github.com/wangyi-fudan/wyhash/
* License: https://github.com/wangyi-fudan/wyhash/blob/master/LICENSE
* License Name: Unlicense
* License Id: Unlicense

### xxHash

* Name: xxHash
* Version: 0.8.0
* Date: 2021-03-17 17:51:40 +01:00
* GitHub: https://github.com/Cyan4973/xxHash/
* License: https://raw.githubusercontent.com/Cyan4973/xxHash/master/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

### zlib

* Name: zlib
* Version: 1.2.13
* Date: 2022-10-13
* Project Home: https://github.com/madler/zlib/
* License: https://raw.githubusercontent.com/madler/zlib/master/README
* License Comment: free as-is license

## Libraries used by iresearch

The ArangoDB software makes uses of the 
[iresearch library](https://github.com/iresearch-toolkit/iresearch),
which is mainly developed by ArangoDB, too.
The iresearch library itself makes use of several other components with
different licenses. The full list of components and their licenses
can be found [here](https://github.com/arangodb/arangodb/blob/devel/lib/iresearch/THIRD_PARTY_README.md).

## Libraries used by faiss

### OpenMP implementation by LLVM

* Name: OpenMP
* Version: 16.0.6
* Date: 2023-06-14
* Project Home: https://github.com/llvm/llvm-project
* License: https://github.com/llvm/llvm-project/blob/main/LICENSE.TXT
* License Name: Apache License 2.0
* License Id: Apache-2.0

### LAPACK

* Name: LAPACK
* Version: 3.10.0
* Date: 2021-06-28
* Project Home: https://www.netlib.org/lapack/
* License: https://www.netlib.org/lapack/LICENSE.txt
* License Comment: The license used for the software is the modified BSD license

### Fortran

* Name: gfortran
* Version: 11.4.0 
* Date: 2023-05-29
* Project Home: https://gcc.gnu.org/wiki/GFortran
* License: https://moinmo.in/GPL
* License Id: GPLv2

## Programs

### Bison

* Name: bison
* Version: 3.4.1
* Date: 2019-05-22 05:28:15Z
* Project Home: https://www.gnu.org/software/bison/
* License: https://raw.githubusercontent.com/arangodb/arangodb/devel/arangod/Aql/grammar.cpp
* License Comment: only used to generate code, not part of the distribution;
  for details about using Bison in this way see
  http://www.gnu.org/software/bison/manual/bison.html#Conditions

  As a special exception, you may create a larger work that contains part or
  all of the Bison parser skeleton and distribute that work under terms of your
  choice, so long as that work isn't itself a parser generator using the
  skeleton or a modified version thereof as a parser skeleton. Alternatively,
  if you modify or redistribute the parser skeleton itself, you may (at your
  option) remove this special exception, which will cause the skeleton and the
  resulting Bison output files to be licensed under the
  GNU General Public License without this special exception.

### cmake

* Name: cmake
* Version: 3.8
* Project Home: https://cmake.org/
* License: https://gitlab.kitware.com/cmake/cmake/raw/master/Copyright.txt
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

### Flex

* Name: flex
* Version: 2.5.35
* Date: 2008-02-26
* Project Home: https://github.com/westes/flex
* License: https://raw.githubusercontent.com/westes/flex/master/COPYING
* License Comment: free as-is license (BSD-2-Clause variant),
  only used to generate code, not part of the distribution

### fmt

* Name: fmt
* Version: 9.1.0
* Date: 2022-08-27 08:57:10-0700
* Project Home: https://fmt.dev/
* License: https://github.com/fmtlib/fmt/blob/master/LICENSE.rst
* License Name: MIT
* License Id: MIT

## Data files

#### IANA Time Zone Database (tzdata)

Name: Time Zone Database
Version: 2020f
Date: 2020-12-29
Project https://www.iana.org/time-zones
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/3rdParty/tzdata/LICENSE
License Name: Public Domain
License Id: -

#### Unicode CLDR Project (windowsZones.xml)

Name: Unicode CLDR Project
Version: 38.1
Date: 2020-11-19
Project Home: https://github.com/unicode-org/cldr
License: https://raw.githubusercontent.com/unicode-org/cldr/master/ICU-LICENSE
License Name: ICU License
License Id: ICU

#### The Project Gutenberg eBook, Children of the Frost, by Jack London

Name: The Project Gutenberg eBook, Children of the Frost, by Jack London
Version: N/A
Date: N/A
Project Home: https://www.gutenberg.org/ebooks/10736
License: https://www.gutenberg.org/policy/license.html
License Name: The Project Gutenberg License
License Id: -

#### The Project Gutenberg eBook of A Dream Of Red Mansions, by Xueqin Cao

Name: The Project Gutenberg eBook of A Dream Of Red Mansions, by Xueqin Cao
Version: N/A
Date: N/A
Project Home: https://www.gutenberg.org/ebooks/24264
License: https://www.gutenberg.org/policy/license.html
License Name: The Project Gutenberg License
License Id: -

## JavaScript

### Node core modules

#### node

* Name: node
* Version: 2017
* Project Home: http://nodejs.org
* GitHub: https://github.com/nodejs/node
* License: https://raw.githubusercontent.com/nodejs/node/master/LICENSE
* License Comment: for all files except punycode.js

#### punycode

* Name: punycode
* Version: 2017
* License: https://raw.githubusercontent.com/bestiejs/punycode.js/master/LICENSE-MIT.txt
* License Name: MIT License
* License Id: MIT

### Backend libraries

#### AsciiTable

* Name ascii-table
* Version: 0.0.8
* GitHub: https://github.com/sorensen/ascii-table
* License: https://github.com/sorensen/ascii-table/blob/master/license
* License Name: MIT License
* License Id: MIT

#### JSUnity

* Name: jsunity
* Version: 0.6
* GitHub: https://github.com/atesgoral/jsunity
* License: https://raw.githubusercontent.com/atesgoral/jsunity/master/LICENSE.txt
* License Name: MIT License
* License Id: MIT

### Frontend libraries

#### Ace

* Name: ace
* Version: 2010
* GitHub: https://github.com/ajaxorg/ace
* License: https://raw.githubusercontent.com/ajaxorg/ace/master/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### Animate.css

* Name: animate.css
* Version: 2015
* GitHub: https://github.com/daneden/animate.css
* License: https://raw.githubusercontent.com/daneden/animate.css/master/LICENSE
* License Name: MIT License
* License Id: MIT

#### Backbone.js

* Name: backbone.js
* Version: 2016
* Project Home: http://backbonejs.org
* GitHub: https://github.com/jashkenas/backbone
* License: https://raw.githubusercontent.com/jashkenas/backbone/master/LICENSE
* License Comment: free as-is license

#### Bootstrap

* Name: bootstrap
* Version: 2015
* Project Home: http://getbootstrap.com
* GitHub: https://github.com/twbs/bootstrap
* License: https://raw.githubusercontent.com/twbs/bootstrap/master/LICENSE
* License Name: MIT License
* License Id: MIT

#### D3

* Name: D3.js
* Version: 2016 
* Project Home: http://d3js.org
* GitHub: https://github.com/mbostock/d3
* License: https://raw.githubusercontent.com/mbostock/d3/master/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### dygraph

* Name: dygraph
* Version: 2018
* Project Home: http://dygraphs.com
* GitHub: https://github.com/danvk/dygraphs
* License: https://raw.githubusercontent.com/danvk/dygraphs/master/LICENSE.txt
* License Comment: free as-is license

#### jQuery

* Name: jquery
* Version: 2.1.0
* Project Home: http://jquery.com
* GitHub: https://github.com/jquery/jquery
* License: https://raw.githubusercontent.com/jquery/jquery/master/LICENSE.txt
* License Comment: free as-is license

#### jQuery Contextmenu

* Name: jquery.contextmenu
* Version: 2015
* GitHub: https://github.com/swisnl/jQuery-contextMenu
* License: https://raw.githubusercontent.com/swisnl/jQuery-contextMenu/master/README.md
  under "License"
* License Name: MIT License
* License Id: MIT

#### jQuery Form

* Name: jquery.form
* Version: 2015
* GitHub: https://github.com/malsup/form/
* License: https://raw.githubusercontent.com/malsup/form/master/README.md
  under "Copyright and License"
* License Name: MIT License
* License Id: MIT
* License Comment: This project is dual licensed under the LGPLv2.1 (or later) or MIT licenses

#### jQuery Hotkeys

* Name: jquery.hotkeys
* Version: 2015
* GitHub: https://github.com/jeresig/jquery.hotkeys
* License: https://raw.githubusercontent.com/jeresig/jquery.hotkeys/master/jquery.hotkeys.js
* License Name: MIT License
* License Id: MIT
* License Comment: Dual licensed under the MIT or GPL Version 2 licenses.

#### jQuery Snippet

* Name: jquery.snippet
* Version: 2015
* Archived Project Home: https://web.archive.org/web/20150908173503/http://www.steamdev.com/snippet/
* License: see https://web.archive.org/web/20150817084109/http://steamdev.com/snippet/
  in "Notes, section 5"
* License Name: MIT License
* License Id: MIT
* License Line: 5.) This script is released under the MIT license and is completely open to modification and redistribution.

#### jQuery Strftime

* Name: strftime
* Version: 2015
* GitHub: https://github.com/samsonjs/strftime
* License: https://raw.githubusercontent.com/samsonjs/strftime/master/Readme.md
  under "License"
* License Name: MIT License
* License Id: MIT

#### jQuery Textfill

* Name: jquery.textfill
* Version: 2015
* GitHub: https://github.com/jquery-textfill/jquery-textfill
* License: https://raw.githubusercontent.com/jquery-textfill/jquery-textfill/master/COPYING.md
* License Name: MIT License
* License Id: MIT

#### jQuery UI

* Name: jquery-ui
* Version: 1.9.2
* Project Home: http://jqueryui.com
* GitHub: https://github.com/jquery/jquery-ui
* License: https://raw.githubusercontent.com/jquery/jquery-ui/master/LICENSE.txt
* License Comment: MIT-style License

#### jQuery UploadFile

* Name: jquery.uploadfile
* Version: 2015
* GitHub: https://github.com/hayageek/jquery-upload-file/
* License: https://raw.githubusercontent.com/hayageek/jquery-upload-file/master/MIT-License.txt
* License Name: MIT License
* License Id: MIT

#### jsoneditor.js

* Name: jsoneditor
* Version: 2018
* GitHub: https://github.com/josdejong/jsoneditor/
* License: https://raw.githubusercontent.com/josdejong/jsoneditor/master/package.json
* License Name: Apache License 2.0
* License Id: Apache-2.0

#### Moment.js

* Name: moment
* Version: 2
* GitHub: https://github.com/moment/moment/
* License: https://raw.githubusercontent.com/moment/moment/develop/LICENSE
* License Name: MIT License
* License Id: MIT

#### nvd3

* Name: nvd3
* Version: 2016
* GitHub: https://github.com/novus/nvd3
* License: https://raw.githubusercontent.com/novus/nvd3/master/package.json
* License Name: Apache License 2.0
* License Id: Apache-2.0

#### Noty

* Name: noty
* Version: 2015
* GitHub: https://github.com/needim/noty/
* License: https://raw.githubusercontent.com/needim/noty/master/LICENSE.txt
* License Name: MIT License
* License Id: MIT

#### Numeral.js

* Name: numeral.js
* Version: 1.5.3
* GitHub: https://github.com/adamwdraper/Numeral-js
* License: https://raw.githubusercontent.com/adamwdraper/Numeral-js/master/LICENSE
* License Name: MIT License
* License Id: MIT

#### prettyBytes.js

* Name: pretty-bytes.js
* Version: 2016
* GitHub: https://github.com/sindresorhus/pretty-bytes
* License: https://raw.githubusercontent.com/sindresorhus/pretty-bytes/master/license
* License Name: MIT License
* License Id: MIT

#### select2

* Name: select2
* Version: 3.4.5
* GitHub: https://github.com/select2/select2
* License: https://raw.githubusercontent.com/select2/select2/master/LICENSE.md
* License Name: MIT License
* License Id: MIT

#### sigma.js

* Name: sigma.js
* Version: 2016
* GitHub: https://github.com/jacomyal/sigma.js
* License: https://raw.githubusercontent.com/jacomyal/sigma.js/master/LICENSE.txt
* License Name: MIT License
* License Id: MIT

#### Swagger UI

* Name: swagger-ui
* Version: 5.4.1
* Project Home: http://swagger.io
* GitHub: https://github.com/swagger-api/swagger-ui
* License: https://raw.githubusercontent.com/swagger-api/swagger-ui/master/LICENSE
* License Name: Apache License 2.0
* License Id: Apache-2.0

#### tippyjs.js

* Name: tippyjs
* Version: 2017
* GitHub: https://github.com/atomiks/tippyjs
* License: https://raw.githubusercontent.com/atomiks/tippyjs/master/LICENSE
* License Name: MIT License
* License Id: MIT

#### wheelnav.js

* Name: wheelnav
* Version: 2016
* GitHub: https://github.com/softwaretailoring/wheelnav
* License: https://raw.githubusercontent.com/softwaretailoring/wheelnav/master/LICENSE
* License Name: MIT License
* License Id: MIT

#### jquery-csv

* Name: jquery.csv
* Version: 2012
* GitHub: https://github.com/evanplaice/jquery-csv
* License: https://raw.githubusercontent.com/evanplaice/jquery-csv/master/LICENSE
* License Name: MIT License
* License Id: MIT

#### Leaflet.js

* Name: leaflet
* Version: 1.3.3
* GitHub: https://github.com/Leaflet/Leaflet
* License: https://raw.githubusercontent.com/Leaflet/Leaflet/master/LICENSE
* License Name: BSD 2-clause "Simplified" License
* License Id: BSD-2-Clause

#### Stamen

* Name: stamen
* Version: 1.3.0
* GitHub: https://github.com/stamen/maps.stamen.com
* License: https://raw.githubusercontent.com/stamen/maps.stamen.com/master/LICENSE
* License Name: BSD 3-clause "New" or "Revised" License
* License Id: BSD-3-Clause

#### randomColor

* Name: randomColor
* Version: 0.4.0
* GitHub: https://github.com/davidmerfield/randomColor
* License: https://raw.githubusercontent.com/davidmerfield/randomColor/0.4.0/LICENSE.md
* License Name: MIT License
* License Id: MIT

### Bundled NPM modules

#### @babel/code-frame

Name: @babel/code-frame
Version: 7.0.0
Project Home: https://github.com/babel/babel/tree/master/packages/babel-code-frame
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/@babel/code-frame/LICENSE
License Name: MIT License
License Id: MIT

#### @babel/highlight

Name: @babel/highlight
Version: 7.0.0
Project Home: https://github.com/babel/babel/tree/master/packages/babel-highlight
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/@babel/highlight/LICENSE
License Name: MIT License
License Id: MIT

#### accepts

Name: accepts
Version: 1.3.5
Project Home: https://github.com/jshttp/accepts
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/accepts/LICENSE
License Name: MIT License
License Id: MIT

#### acorn-jsx

Name: acorn-jsx
Version: 5.0.1
Project Home: https://github.com/RReverser/acorn-jsx
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/acorn-jsx/LICENSE
License Name: MIT License
License Id: MIT

#### acorn

Name: acorn
Version: 6.1.1
Project Home: https://github.com/acornjs/acorn
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/acorn/LICENSE
License Name: MIT License
License Id: MIT

#### ajv

Name: ajv
Version: 8.2.0
Project Home: https://github.com/epoberezkin/ajv
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ajv/LICENSE
License Name: MIT License
License Id: MIT

#### ajv

Name: ajv
Version: 6.10.0
Project Home: https://github.com/epoberezkin/ajv
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/ajv/LICENSE
License Name: MIT License
License Id: MIT

#### ansi-escapes

Name: ansi-escapes
Version: 3.2.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/ansi-escapes/license
License Name: MIT License
License Id: MIT

#### ansi-html-community

Name: ansi-html-community
Version: 0.0.8
Project Home: https://github.com/mahdyar/ansi-html-community
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ansi-html-community/LICENSE
License Name: Apache License 2.0
License Id: Apache-2.0

#### ansi-regex

Name: ansi-regex
Version: 3.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/ansi-regex/license
License Name: MIT License
License Id: MIT

#### ansi-regex

Name: ansi-regex
Version: 4.1.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/inquirer/node_modules/ansi-regex/license
License Name: MIT License
License Id: MIT

#### ansi-styles

Name: ansi-styles
Version: 3.2.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/ansi-styles/license
License Name: MIT License
License Id: MIT

#### ansi_up

Name: ansi_up
Version: 4.0.3
Project Home: https://github.com/drudru/ansi_up
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ansi_up/Readme.md
License Name: MIT License
License Id: MIT

#### aqb

Name: aqb
Version: 2.1.0
Project Home: https://github.com/arangodb/aqbjs
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/aqb/LICENSE
License Name: Apache License 2.0
License Id: Apache-2.0

#### argparse

Name: argparse
Version: 1.0.10
Project Home: https://github.com/nodeca/argparse
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/js-yaml/node_modules/argparse/LICENSE
License Name: MIT License
License Id: MIT

#### assertion-error

Name: assertion-error
Version: 1.0.2
Project Home: http://qualiancy.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/chai/node_modules/assertion-error/README.md
License Name: MIT License
License Id: MIT

#### astral-regex

Name: astral-regex
Version: 1.0.0
Project Home: github.com/kevva
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/astral-regex/license
License Name: MIT License
License Id: MIT

#### babel-code-frame

Name: babel-code-frame
Version: 6.26.0
Project Home: https://github.com/babel/babel/tree/master/packages/babel-code-frame
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/babel-code-frame/README.md
License Name: MIT License
License Id: MIT

#### balanced-match

Name: balanced-match
Version: 1.0.0
Project Home: http://juliangruber.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/minimatch/node_modules/balanced-match/LICENSE.md
License Name: MIT License
License Id: MIT

#### brace-expansion

Name: brace-expansion
Version: 1.1.8
Project Home: http://juliangruber.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/minimatch/node_modules/brace-expansion/README.md
License Name: MIT License
License Id: MIT

#### callsites

Name: callsites
Version: 3.1.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/callsites/license
License Name: MIT License
License Id: MIT

#### chai

Name: chai
Version: 3.5.0
Project Home: https://github.com/chaijs/chai
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/chai/README.md
License Name: MIT License
License Id: MIT

#### chalk

Name: chalk
Version: 2.4.2
Project Home: https://github.com/chalk/chalk
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/chalk/license
License Name: MIT License
License Id: MIT

#### chardet

Name: chardet
Version: 0.7.0
Project Home: https://github.com/runk/node-chardet
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/chardet/LICENSE
License Name: MIT License
License Id: MIT

#### cli-cursor

Name: cli-cursor
Version: 2.1.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/cli-cursor/license
License Name: MIT License
License Id: MIT

#### cli-width

Name: cli-width
Version: 2.2.0
Project Home: https://github.com/knownasilya/cli-width
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/cli-width/LICENSE
License Name: ISC License
License Id: ISC

#### color-convert

Name: color-convert
Version: 1.9.3
Project Home: https://github.com/Qix-/color-convert
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/color-convert/LICENSE
License Name: MIT License
License Id: MIT

#### color-name

Name: color-name
Version: 1.1.3
Project Home: https://github.com/dfcreative/color-name
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/color-name/LICENSE
License Name: MIT License
License Id: MIT

#### concat-map

Name: concat-map
Version: 0.0.1
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/minimatch/node_modules/concat-map/LICENSE
License Name: MIT License
License Id: MIT

#### content-disposition

Name: content-disposition
Version: 0.5.3
Project Home: https://github.com/jshttp/content-disposition
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/content-disposition/LICENSE
License Name: MIT License
License Id: MIT

#### content-type

Name: content-type
Version: 1.0.4
Project Home: https://github.com/jshttp/content-type
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/content-type/LICENSE
License Name: MIT License
License Id: MIT

#### cross-spawn

Name: cross-spawn
Version: 6.0.5
Project Home: https://github.com/moxystudio/node-cross-spawn
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/cross-spawn/LICENSE
License Name: MIT License
License Id: MIT

#### debug

Name: debug
Version: 4.1.1
Project Home: https://github.com/visionmedia/debug
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/debug/LICENSE
License Name: MIT License
License Id: MIT

#### dedent

Name: dedent
Version: 0.7.0
Project Home: http://desmondbrand.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/dedent/LICENSE
License Name: MIT License
License Id: MIT

#### deep-eql

Name: deep-eql
Version: 0.1.3
Project Home: https://github.com/chaijs/deep-eql
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/chai/node_modules/deep-eql/README.md
License Name: MIT License
License Id: MIT

#### deep-is

Name: deep-is
Version: 0.1.3
Project Home: http://thlorenz.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/deep-is/LICENSE
License Name: MIT License
License Id: MIT

#### depd

Name: depd
Version: 1.1.2
Project Home: https://github.com/dougwilson/nodejs-depd
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/http-errors/node_modules/depd/LICENSE
License Name: MIT License
License Id: MIT

#### doctrine

Name: doctrine
Version: 3.0.0
Project Home: https://github.com/eslint/doctrine
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/doctrine/LICENSE
License Name: Apache License 2.0
License Id: Apache-2.0

#### emoji-regex

Name: emoji-regex
Version: 7.0.3
Project Home: https://mathiasbynens.be/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/emoji-regex/LICENSE-MIT.txt
License Name: MIT License
License Id: MIT

#### error-stack-parser

Name: error-stack-parser
Version: 2.0.2
Project Home: https://github.com/stacktracejs/error-stack-parser
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/error-stack-parser/LICENSE
License Name: MIT License
License Id: MIT

#### eslint-scope

Name: eslint-scope
Version: 4.0.3
Project Home: https://github.com/eslint/eslint-scope
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/eslint-scope/LICENSE
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### eslint-utils

Name: eslint-utils
Version: 1.3.1
Project Home: https://github.com/mysticatea/eslint-utils
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/eslint-utils/LICENSE
License Name: MIT License
License Id: MIT

#### eslint-visitor-keys

Name: eslint-visitor-keys
Version: 1.0.0
Project Home: https://github.com/mysticatea
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/eslint-visitor-keys/LICENSE
License Name: Apache License 2.0
License Id: Apache-2.0

#### eslint

Name: eslint
Version: 5.16.0
Project Home: https://github.com/eslint/eslint
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/LICENSE
License Name: MIT License
License Id: MIT

#### espree

Name: espree
Version: 5.0.1
Project Home: https://github.com/eslint/espree
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/espree/LICENSE
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### esprima

Name: esprima
Version: 4.0.1
Project Home: https://github.com/jquery/esprima
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/js-yaml/node_modules/esprima/LICENSE.BSD
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### esquery

Name: esquery
Version: 1.0.1
Project Home: https://github.com/jrfeenst/esquery
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/esquery/license.txt
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### esrecurse

Name: esrecurse
Version: 4.2.1
Project Home: https://github.com/estools/esrecurse
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/esrecurse/README.md
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### estraverse

Name: estraverse
Version: 4.2.0
Project Home: https://github.com/estools/estraverse
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/estraverse/LICENSE.BSD
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### esutils

Name: esutils
Version: 2.0.2
Project Home: https://github.com/estools/esutils
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/babel-code-frame/node_modules/esutils/LICENSE.BSD
License Name: BSD License
License Id: BSD

#### extendible

Name: extendible
Version: 0.1.1
Project Home: https://github.com/bigpipe/extendible
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/extendible/README.md
License Name: MIT License
License Id: MIT

#### external-editor

Name: external-editor
Version: 3.0.3
Project Home: https://mrkmg.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/external-editor/LICENSE
License Name: MIT License
License Id: MIT

#### fast-deep-equal

Name: fast-deep-equal
Version: 3.1.3
Project Home: https://github.com/epoberezkin/fast-deep-equal
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ajv/node_modules/fast-deep-equal/LICENSE
License Name: MIT License
License Id: MIT

#### fast-deep-equal

Name: fast-deep-equal
Version: 2.0.1
Project Home: https://github.com/epoberezkin/fast-deep-equal
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/fast-deep-equal/LICENSE
License Name: MIT License
License Id: MIT

#### fast-json-stable-stringify

Name: fast-json-stable-stringify
Version: 2.0.0
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/fast-json-stable-stringify/LICENSE
License Name: MIT License
License Id: MIT

#### fast-levenshtein

Name: fast-levenshtein
Version: 2.0.6
Project Home: http://www.hiddentao.com/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/fast-levenshtein/LICENSE.md
License Name: MIT License
License Id: MIT

#### figures

Name: figures
Version: 2.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/figures/license
License Name: MIT License
License Id: MIT

#### file-entry-cache

Name: file-entry-cache
Version: 5.0.1
Project Home: http://royriojas.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/file-entry-cache/LICENSE
License Name: MIT License
License Id: MIT

#### flat-cache

Name: flat-cache
Version: 2.0.1
Project Home: http://royriojas.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/flat-cache/LICENSE
License Name: MIT License
License Id: MIT

#### flatted

Name: flatted
Version: 2.0.0
Project Home: https://github.com/WebReflection/flatted
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/flatted/LICENSE
License Name: ISC License
License Id: ISC

#### formatio

Name: formatio
Version: 1.1.1
Project Home: https://github.com/busterjs/formatio
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/sinon/node_modules/formatio/LICENSE
License Name: BSD License
License Id: BSD

#### fs.realpath

Name: fs.realpath
Version: 1.0.0
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/fs.realpath/LICENSE
License Name: ISC License
License Id: ISC

#### functional-red-black-tree

Name: functional-red-black-tree
Version: 1.0.1
Project Home: https://github.com/mikolalysenko/functional-red-black-tree
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/functional-red-black-tree/LICENSE
License Name: MIT License
License Id: MIT

#### glob

Name: glob
Version: 7.1.3
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/glob/LICENSE
License Name: ISC License
License Id: ISC

#### globals

Name: globals
Version: 11.11.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/globals/license
License Name: MIT License
License Id: MIT

#### graphql-sync

Name: graphql-sync
Version: 0.6.2-sync
Project Home: https://github.com/arangodb/graphql-sync
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/graphql-sync/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### graphql

Name: graphql
Version: 0.6.2
Project Home: https://github.com/graphql/graphql-js
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/graphql-sync/node_modules/graphql/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### has-flag

Name: has-flag
Version: 3.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/has-flag/license
License Name: MIT License
License Id: MIT

#### highlight.js

Name: highlight.js
Version: 10.7.3
Project Home: https://github.com/highlightjs/highlight.js
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/highlight.js/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### hoek

Name: hoek
Version: 6.1.3
Project Home: https://github.com/hapijs/hoek
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/joi/node_modules/hoek/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### http-errors

Name: http-errors
Version: 1.7.2
Project Home: http://jongleberry.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/http-errors/LICENSE
License Name: MIT License
License Id: MIT

#### i

Name: i
Version: 0.3.6
Project Home: pksunkara.github.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/i/LICENSE
License Name: MIT License
License Id: MIT

#### iconv-lite

Name: iconv-lite
Version: 0.6.3
Project Home: https://github.com/ashtuchkin/iconv-lite
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/iconv-lite/LICENSE
License Name: MIT License
License Id: MIT

#### ignore

Name: ignore
Version: 4.0.6
Project Home: https://github.com/kaelzhang/node-ignore
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/ignore/LICENSE-MIT
License Name: MIT License
License Id: MIT

#### import-fresh

Name: import-fresh
Version: 3.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/import-fresh/license
License Name: MIT License
License Id: MIT

#### imurmurhash

Name: imurmurhash
Version: 0.1.4
Project Home: https://github.com/homebrewing
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/imurmurhash/README.md
License Name: MIT License
License Id: MIT

#### inflight

Name: inflight
Version: 1.0.6
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/inflight/LICENSE
License Name: ISC License
License Id: ISC

#### inherits

Name: inherits
Version: 2.0.1
Project Home: https://github.com/isaacs/inherits
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/sinon/node_modules/inherits/LICENSE
License Name: ISC License
License Id: ISC

#### inherits

Name: inherits
Version: 2.0.3
Project Home: https://github.com/isaacs/inherits
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/inherits/LICENSE
License Name: ISC License
License Id: ISC

#### inquirer

Name: inquirer
Version: 6.3.1
Project Home: https://github.com/SBoudrias/Inquirer.js
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/inquirer/LICENSE
License Name: MIT License
License Id: MIT

#### is-fullwidth-code-point

Name: is-fullwidth-code-point
Version: 2.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/is-fullwidth-code-point/license
License Name: MIT License
License Id: MIT

#### is-promise

Name: is-promise
Version: 2.1.0
Project Home: https://github.com/then/is-promise
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/is-promise/LICENSE
License Name: MIT License
License Id: MIT

#### is-wsl

* Name: is-wsl
* Version: 2.2.0
* Project Home: https://github.com/sindresorhus/is-wsl
* License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/node-netstat/node_modules/is-wsl/LICENSE
* License Name: MIT License
* License Id: MIT

#### isemail

Name: isemail
Version: 3.2.0
Project Home: https://github.com/hapijs/isemail
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/joi/node_modules/isemail/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### isexe

Name: isexe
Version: 2.0.0
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/isexe/LICENSE
License Name: ISC License
License Id: ISC

#### iterall

Name: iterall
Version: 1.0.2
Project Home: http://leebyron.com/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/graphql-sync/node_modules/iterall/LICENSE
License Name: MIT License
License Id: MIT

#### joi-to-json-schema

Name: joi-to-json-schema
Version: 4.0.1
Project Home: https://github.com/lightsofapollo/joi-to-json-schema
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/joi-to-json-schema/README.md
License Name: Apache License 2.0
License Id: Apache-2.0

#### joi

Name: joi
Version: 14.3.1
Project Home: https://github.com/hapijs/joi
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/joi/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### js-tokens

Name: js-tokens
Version: 3.0.2
Project Home: https://github.com/lydell/js-tokens
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/babel-code-frame/node_modules/js-tokens/LICENSE
License Name: MIT License
License Id: MIT

#### js-tokens

Name: js-tokens
Version: 4.0.0
Project Home: https://github.com/lydell/js-tokens
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/js-tokens/LICENSE
License Name: MIT License
License Id: MIT

#### js-yaml

Name: js-yaml
Version: 3.13.1
Project Home: https://github.com/nodeca/js-yaml
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/js-yaml/LICENSE
License Name: MIT License
License Id: MIT

#### json-schema-traverse

Name: json-schema-traverse
Version: 1.0.0
Project Home: https://github.com/epoberezkin/json-schema-traverse
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ajv/node_modules/json-schema-traverse/LICENSE
License Name: MIT License
License Id: MIT

#### json-schema-traverse

Name: json-schema-traverse
Version: 0.4.1
Project Home: https://github.com/epoberezkin/json-schema-traverse
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/json-schema-traverse/LICENSE
License Name: MIT License
License Id: MIT

#### json-stable-stringify-without-jsonify

Name: json-stable-stringify-without-jsonify
Version: 1.0.1
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/json-stable-stringify-without-jsonify/LICENSE
License Name: MIT License
License Id: MIT

#### levn

Name: levn
Version: 0.3.0
Project Home: https://github.com/gkz/levn
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/levn/LICENSE
License Name: MIT License
License Id: MIT

#### lodash

Name: lodash
Version: 4.17.13
Project Home: https://github.com/lodash/lodash
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/lodash/LICENSE
License Name: MIT License
License Id: MIT

#### lolex

Name: lolex
Version: 1.3.2
Project Home: https://github.com/sinonjs/lolex
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/sinon/node_modules/lolex/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### media-typer

* Name: media-typer
* Version: 0.3.0
* Project Home: https://github.com/jshttp/media-typer
* License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/type-is/node_modules/media-typer/LICENSE
* License Name: MIT License
* License Id: MIT

#### mime-db

Name: mime-db
Version: 1.38.0
Project Home: https://github.com/jshttp/mime-db
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/mime-types/node_modules/mime-db/LICENSE
License Name: MIT License
License Id: MIT

#### mime-types

Name: mime-types
Version: 2.1.31
Project Home: https://github.com/jshttp/mime-types
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/mime-types/LICENSE
License Name: MIT License
License Id: MIT

#### mimic-fn

Name: mimic-fn
Version: 1.2.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/mimic-fn/license
License Name: MIT License
License Id: MIT

#### minimatch

Name: minimatch
Version: 3.0.4
Project Home: http://blog.izs.me
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/minimatch/LICENSE
License Name: ISC License
License Id: ISC

#### minimist

Name: minimist
Version: 0.0.8
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/minimist/LICENSE
License Name: MIT License
License Id: MIT

#### mkdirp

Name: mkdirp
Version: 0.5.1
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/mkdirp/LICENSE
License Name: MIT License
License Id: MIT

#### ms

Name: ms
Version: 2.1.3
Project Home: https://github.com/zeit/ms
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ms/license.md
License Name: MIT License
License Id: MIT

#### mute-stream

Name: mute-stream
Version: 0.0.7
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/mute-stream/LICENSE
License Name: ISC License
License Id: ISC

#### natural-compare

Name: natural-compare
Version: 1.4.0
Project Home: https://github.com/litejs/natural-compare-lite
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/natural-compare/README.md
License Name: MIT License
License Id: MIT

#### negotiator

Name: negotiator
Version: 0.6.1
Project Home: https://github.com/jshttp/negotiator
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/accepts/node_modules/negotiator/LICENSE
License Name: MIT License
License Id: MIT

#### netmask

Name: netmask
Version: 1.0.6
Project Home: https://github.com/rs/node-netmask
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/netmask/README.md
License Name: MIT License
License Id: MIT

#### nice-try

Name: nice-try
Version: 1.0.5
Project Home: https://github.com/electerious/nice-try
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/nice-try/LICENSE
License Name: MIT License
License Id: MIT


#### node-netstat

Name: node-netstat
Version: 1.8.0 + adjustments for ArangoDB
Project Home: https://github.com/danielkrainas/node-netstat#readme
License: http://unlicense.org/UNLICENSE
License Name: Unlicense / Public Domain
License Id: -

#### once

Name: once
Version: 1.4.0
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/once/LICENSE
License Name: ISC License
License Id: ISC

#### onetime

Name: onetime
Version: 2.0.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/onetime/license
License Name: MIT License
License Id: MIT

#### optionator

Name: optionator
Version: 0.8.2
Project Home: https://github.com/gkz/optionator
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/optionator/LICENSE
License Name: MIT License
License Id: MIT

#### os-tmpdir

Name: os-tmpdir
Version: 1.0.2
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/os-tmpdir/license
License Name: MIT License
License Id: MIT

#### parent-module

Name: parent-module
Version: 1.0.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/parent-module/license
License Name: MIT License
License Id: MIT

#### path-is-absolute

Name: path-is-absolute
Version: 1.0.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/path-is-absolute/license
License Name: MIT License
License Id: MIT

#### path-is-inside

Name: path-is-inside
Version: 1.0.2
Project Home: https://domenic.me
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/path-is-inside/LICENSE.txt
License Name: MIT License
License Id: MIT

#### path-key

Name: path-key
Version: 2.0.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/path-key/license
License Name: MIT License
License Id: MIT

#### prelude-ls

Name: prelude-ls
Version: 1.1.2
Project Home: https://github.com/gkz/prelude-ls
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/prelude-ls/LICENSE
License Name: MIT License
License Id: MIT

#### progress

Name: progress
Version: 2.0.3
Project Home: https://github.com/visionmedia/node-progress
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/progress/LICENSE
License Name: MIT License
License Id: MIT

#### punycode

Name: punycode
Version: 2.1.1
Project Home: https://mathiasbynens.be/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ajv/node_modules/punycode/LICENSE-MIT.txt
License Name: MIT License
License Id: MIT

#### punycode

Name: punycode
Version: 2.1.1
Project Home: https://mathiasbynens.be/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/punycode/LICENSE-MIT.txt
License Name: MIT License
License Id: MIT

#### qs

Name: qs
Version: 6.7.0
Project Home: https://github.com/ljharb/qs
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/qs/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### range-parser

Name: range-parser
Version: 1.2.0
Project Home: http://tjholowaychuk.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/range-parser/LICENSE
License Name: MIT License
License Id: MIT

#### regexpp

Name: regexpp
Version: 2.0.1
Project Home: https://github.com/mysticatea
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/regexpp/LICENSE
License Name: MIT License
License Id: MIT

#### require-from-string

Name: require-from-string
Version: 2.0.2
Project Home: https://github.com/floatdrop/require-from-string#readme
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ajv/node_modules/require-from-string/license
License Name: MIT License
License Id: MIT

#### resolve-from

Name: resolve-from
Version: 4.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/resolve-from/license
License Name: MIT License
License Id: MIT

#### restore-cursor

Name: restore-cursor
Version: 2.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/restore-cursor/license
License Name: MIT License
License Id: MIT

#### rimraf

Name: rimraf
Version: 2.6.3
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/rimraf/LICENSE
License Name: ISC License
License Id: ISC

#### run-async

Name: run-async
Version: 2.3.0
Project Home: https://github.com/SBoudrias/run-async
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/run-async/LICENSE
License Name: MIT License
License Id: MIT

#### rxjs

Name: rxjs
Version: 6.4.0
Project Home: https://github.com/reactivex/rxjs
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/rxjs/LICENSE.txt
License Name: Apache License 2.0
License Id: Apache-2.0

#### safe-buffer

Name: safe-buffer
Version: 5.1.2
Project Home: http://feross.org
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/content-disposition/node_modules/safe-buffer/LICENSE
License Name: MIT License
License Id: MIT

#### safer-buffer

Name: safer-buffer
Version: 2.1.2
Project Home: https://github.com/ChALkeR
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/safer-buffer/LICENSE
License Name: MIT License
License Id: MIT

#### samsam

Name: samsam
Version: 1.1.2
Project Home: https://github.com/busterjs/samsam
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/sinon/node_modules/samsam/LICENSE
License Name: BSD License
License Id: BSD

#### semver

Name: semver
Version: 5.7.0
Project Home: https://github.com/npm/node-semver
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/semver/LICENSE
License Name: ISC License
License Id: ISC

#### semver

Name: semver
Version: 6.0.0
Project Home: https://github.com/npm/node-semver
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/semver/LICENSE
License Name: ISC License
License Id: ISC

#### setprototypeof

Name: setprototypeof
Version: 1.1.1
Project Home: https://github.com/wesleytodd/setprototypeof
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/http-errors/node_modules/setprototypeof/LICENSE
License Name: ISC License
License Id: ISC

#### shebang-command

Name: shebang-command
Version: 1.2.0
Project Home: github.com/kevva
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/shebang-command/license
License Name: MIT License
License Id: MIT

#### shebang-regex

Name: shebang-regex
Version: 1.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/shebang-regex/license
License Name: MIT License
License Id: MIT

#### signal-exit

Name: signal-exit
Version: 3.0.2
Project Home: https://github.com/tapjs/signal-exit
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/signal-exit/LICENSE.txt
License Name: ISC License
License Id: ISC

#### sinon

Name: sinon
Version: 1.17.7
Project Home: https://github.com/cjohansen/Sinon.JS
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/sinon/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### slice-ansi

Name: slice-ansi
Version: 2.1.0
Project Home: https://github.com/chalk/slice-ansi
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/slice-ansi/license
License Name: MIT License
License Id: MIT

#### sprintf-js

Name: sprintf-js
Version: 1.0.3
Project Home: http://alexei.ro/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/js-yaml/node_modules/sprintf-js/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### stackframe

Name: stackframe
Version: 1.0.4
Project Home: https://github.com/stacktracejs/stackframe
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/error-stack-parser/node_modules/stackframe/LICENSE
License Name: MIT License
License Id: MIT

#### statuses

Name: statuses
Version: 1.5.0
Project Home: https://github.com/jshttp/statuses
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/statuses/LICENSE
License Name: MIT License
License Id: MIT

#### string-width

Name: string-width
Version: 2.1.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/string-width/license
License Name: MIT License
License Id: MIT

#### string-width

Name: string-width
Version: 3.1.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/table/node_modules/string-width/license
License Name: MIT License
License Id: MIT

#### strip-ansi

Name: strip-ansi
Version: 4.0.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/strip-ansi/license
License Name: MIT License
License Id: MIT

#### strip-ansi

Name: strip-ansi
Version: 5.2.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/inquirer/node_modules/strip-ansi/license
License Name: MIT License
License Id: MIT

#### strip-json-comments

Name: strip-json-comments
Version: 2.0.1
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/strip-json-comments/license
License Name: MIT License
License Id: MIT

#### supports-color

Name: supports-color
Version: 5.5.0
Project Home: sindresorhus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/supports-color/license
License Name: MIT License
License Id: MIT

#### table

Name: table
Version: 5.2.3
Project Home: http://gajus.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/table/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### text-table

Name: text-table
Version: 0.2.0
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/text-table/LICENSE
License Name: MIT License
License Id: MIT

#### through

Name: through
Version: 2.3.8
Project Home: dominictarr.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/through/LICENSE.APACHE2
License Name: MIT License
License Id: MIT

#### timezone

Name: timezone
Version: 1.0.22
Project Home: https://github.com/bigeasy/timezone
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/timezone/README.md
License Name: MIT License
License Id: MIT

#### tmp

Name: tmp
Version: 0.0.33
Project Home: http://raszi.hu/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/tmp/LICENSE
License Name: MIT License
License Id: MIT

#### toidentifier

Name: toidentifier
Version: 1.0.0
Project Home: https://github.com/component/toidentifier
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/http-errors/node_modules/toidentifier/LICENSE
License Name: MIT License
License Id: MIT

#### topo

Name: topo
Version: 3.0.3
Project Home: https://github.com/hapijs/topo
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/joi/node_modules/topo/LICENSE
License Name: BSD 3-clause "New" or "Revised" License
License Id: BSD-3-Clause

#### tslib

Name: tslib
Version: 1.9.3
Project Home: https://github.com/Microsoft/tslib
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/tslib/LICENSE.txt
License Name: Apache License 2.0
License Id: Apache-2.0

#### type-check

Name: type-check
Version: 0.3.2
Project Home: https://github.com/gkz/type-check
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/type-check/LICENSE
License Name: MIT License
License Id: MIT

#### type-detect

Name: type-detect
Version: 0.1.1
Project Home: http://alogicalparadox.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/chai/node_modules/deep-eql/node_modules/type-detect/README.md
License Name: MIT License
License Id: MIT

#### type-detect

Name: type-detect
Version: 1.0.0
Project Home: http://alogicalparadox.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/chai/node_modules/type-detect/README.md
License Name: MIT License
License Id: MIT

#### type-is

Name: type-is
Version: 1.6.16
Project Home: https://github.com/jshttp/type-is
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/type-is/LICENSE
License Name: MIT License
License Id: MIT

#### uri-js

Name: uri-js
Version: 4.2.2
Project Home: https://github.com/garycourt/uri-js
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/uri-js/README.md
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### uri-js

Name: uri-js
Version: 4.2.2
Project Home: https://github.com/garycourt/uri-js
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/ajv/node_modules/uri-js/README.md
License Name: BSD 2-clause "Simplified" License
License Id: BSD-2-Clause

#### util

Name: util
Version: 0.10.3
Project Home: http://www.joyent.com
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/sinon/node_modules/util/LICENSE
License Name: MIT License
License Id: MIT

#### vary

Name: vary
Version: 1.1.2
Project Home: https://github.com/jshttp/vary
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/vary/LICENSE
License Name: MIT License
License Id: MIT

#### which

Name: which
Version: 1.3.1
Project Home: http://blog.izs.me
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/which/LICENSE
License Name: ISC License
License Id: ISC

#### wordwrap

Name: wordwrap
Version: 1.0.0
Project Home: http://substack.net
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/wordwrap/LICENSE
License Name: MIT License
License Id: MIT

#### wrappy

Name: wrappy
Version: 1.0.2
Project Home: http://blog.izs.me/
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/wrappy/LICENSE
License Name: ISC License
License Id: ISC

#### write

Name: write
Version: 1.0.3
Project Home: https://github.com/jonschlinkert
License: https://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/eslint/node_modules/write/LICENSE
License Name: MIT License
License Id: MIT

#### @xmldom/xmldom

Name: @xmldom/xmldom
Version: 0.8.0
Project Home: https://github.com/xmldom/xmldom
License: httpsx://raw.githubusercontent.com/arangodb/arangodb/devel/js/node/node_modules/xmldom/LICENSE
License Name: MIT (dual license)
License Id: MIT
