'use strict';

// //////////////////////////////////////////////////////////////////////////////
// / DISCLAIMER
// /
// / Copyright 2014-2024 ArangoDB GmbH, Cologne, Germany
// / Copyright 2004-2014 triAGENS GmbH, Cologne, Germany
// /
// / Licensed under the Business Source License 1.1 (the "License");
// / you may not use this file except in compliance with the License.
// / You may obtain a copy of the License at
// /
// /     https://github.com/arangodb/arangodb/blob/devel/LICENSE
// /
// / Unless required by applicable law or agreed to in writing, software
// / distributed under the License is distributed on an "AS IS" BASIS,
// / WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// / See the License for the specific language governing permissions and
// / limitations under the License.
// /
// / Copyright holder is ArangoDB GmbH, Cologne, Germany
// /
// / @author Dr. Frank Celler
// //////////////////////////////////////////////////////////////////////////////

module.isSystem = true;

var common = require('@arangodb/common');
const semver = require('semver');

Object.keys(common).forEach(function (key) {
  exports[key] = common[key];
});

var internal = require('internal'); // OK: db

// //////////////////////////////////////////////////////////////////////////////
// / @brief isServer
// //////////////////////////////////////////////////////////////////////////////

exports.isServer = true;

// //////////////////////////////////////////////////////////////////////////////
// / @brief isClient
// //////////////////////////////////////////////////////////////////////////////

exports.isClient = false;

// //////////////////////////////////////////////////////////////////////////////
// / @brief class "ArangoCollection"
// //////////////////////////////////////////////////////////////////////////////

// cannot yet not use arangodb
exports.ArangoCollection = require('@arangodb/arango-collection').ArangoCollection;

// //////////////////////////////////////////////////////////////////////////////
// / @brief class "ArangoDatabase"
// //////////////////////////////////////////////////////////////////////////////

// cannot yet not use arangodb
exports.ArangoDatabase = require('@arangodb/arango-database').ArangoDatabase;

// //////////////////////////////////////////////////////////////////////////////
// / @brief class "ArangoStatement"
// //////////////////////////////////////////////////////////////////////////////

// cannot yet not use arangodb
exports.ArangoStatement = require('@arangodb/arango-statement').ArangoStatement;

exports.ArangoView = require('@arangodb/arango-view').ArangoView;

// //////////////////////////////////////////////////////////////////////////////
// / @brief the global db object
// //////////////////////////////////////////////////////////////////////////////

exports.db = internal.db;

// //////////////////////////////////////////////////////////////////////////////
// / @brief the server version
// //////////////////////////////////////////////////////////////////////////////

exports.plainServerVersion = function () {
  let version = internal.version;

  if (semver.valid(version)) {
    version = semver.major(version) + '.' + semver.minor(version) + '.' + semver.patch(version);
  }

  return version;
};
