'use strict';

// //////////////////////////////////////////////////////////////////////////////
// DISCLAIMER
//
// Copyright 2022 ArangoDB GmbH, Cologne, Germany
//
// The Programs (which include both the software and documentation) contain
// proprietary information of ArangoDB GmbH; they are provided under a license
// agreement containing restrictions on use and disclosure and are also
// protected by copyright, patent and other intellectual and industrial
// property laws. Reverse engineering, disassembly or decompilation of the
// Programs, except to the extent required to obtain interoperability with
// other independently created software or as specified by law, is prohibited.
//
// It shall be the licensee's responsibility to take all appropriate fail-safe,
// backup, redundancy, and other measures to ensure the safe use of
// applications if the Programs are used for purposes such as nuclear,
// aviation, mass transit, medical, or other inherently dangerous applications,
// and ArangoDB GmbH disclaims liability for any damages caused by such use of
// the Programs.
//
// This software is the confidential and proprietary information of ArangoDB
// GmbH. You shall not disclose such confidential and proprietary information
// and shall use it only in accordance with the terms of the license agreement
// you entered into with ArangoDB GmbH.
//
// @author Michael Hackstein
// //////////////////////////////////////////////////////////////////////////////

const {GeneralGraph} = require('@arangodb/graph-classes');

const createHiddenProperty = (obj, name, value) => {
  Object.defineProperty(obj, name, {
    enumerable: false,
    writable: true
  });
  obj[name] = value;
};

class SatelliteGraph extends GeneralGraph {
  constructor(info) {
    super(info);
    createHiddenProperty(this, '__initial', info.initial);
    createHiddenProperty(this, '__numberOfShards', 1);
    createHiddenProperty(this, '__replicationFactor', "satellite");
    createHiddenProperty(this, '__isSatellite', true);
  }
}

class SmartGraph extends GeneralGraph {
  constructor(info) {
    super(info);
    createHiddenProperty(this, '__initial', info.initial);
    createHiddenProperty(this, '__numberOfShards', info.numberOfShards);
    createHiddenProperty(this, '__replicationFactor', info.replicationFactor || 1);
    createHiddenProperty(this, '__isSmart', true);
    createHiddenProperty(this, '__smartGraphAttribute', info.smartGraphAttribute);
    createHiddenProperty(this, '__isDisjoint', info.isDisjoint || false);
  }
}

class EnterpriseGraph extends GeneralGraph {
  constructor(info) {
    super(info);
    createHiddenProperty(this, '__initial', info.initial);
    createHiddenProperty(this, '__numberOfShards', info.numberOfShards);
    createHiddenProperty(this, '__replicationFactor', info.replicationFactor || 1);
    createHiddenProperty(this, '__isSmart', true);
    createHiddenProperty(this, '__isDisjoint', info.isDisjoint || false);
  }
}


exports.GeneralGraph = GeneralGraph;
exports.SatelliteGraph = SatelliteGraph;
exports.SmartGraph = SmartGraph;
exports.EnterpriseGraph = EnterpriseGraph;
