'use strict';

// //////////////////////////////////////////////////////////////////////////////
// DISCLAIMER
//
// Copyright 2016 ArangoDB GmbH, Cologne, Germany
//
// The Programs (which include both the software and documentation) contain
// proprietary information of ArangoDB GmbH; they are provided under a license
// agreement containing restrictions on use and disclosure and are also
// protected by copyright, patent and other intellectual and industrial
// property laws. Reverse engineering, disassembly or decompilation of the
// Programs, except to the extent required to obtain interoperability with
// other independently created software or as specified by law, is prohibited.
//
// It shall be the licensee's responsibility to take all appropriate fail-safe,
// backup, redundancy, and other measures to ensure the safe use of
// applications if the Programs are used for purposes such as nuclear,
// aviation, mass transit, medical, or other inherently dangerous applications,
// and ArangoDB GmbH disclaims liability for any damages caused by such use of
// the Programs.
//
// This software is the confidential and proprietary information of ArangoDB
// GmbH. You shall not disclose such confidential and proprietary information
// and shall use it only in accordance with the terms of the license agreement
// you entered into with ArangoDB GmbH.
//
// @author Michael Hackstein
// //////////////////////////////////////////////////////////////////////////////

const errors = require('internal').errors;
const ArangoError = require('@arangodb').ArangoError;

// //////////////////////////////////////////////////////////////////////////////
// / @brief throw an ArangoError
// //////////////////////////////////////////////////////////////////////////////
const raiseError = (code, msg) => {
  let err = new ArangoError();
  err.errorNum = code;
  err.errorMessage = msg;
  throw err;
};

exports.getSmartShards = (dbName, collectionName, ci) => {
  let shards = [];
  if (ci.isSmart && ci.type === 3) { // This is a smartEdgeCollection
    ci = global.ArangoClusterInfo.getCollectionInfo(dbName, '_local_' + collectionName);

    if (ci === undefined || typeof ci !== 'object') {
      throw "unable to determine shard list for '" + dbName + '/' + collectionName + "'";
    }

    for (let shard in ci.shards) {
      if (ci.shards.hasOwnProperty(shard)) {
        shards.push(shard);
      }
    }

    ci = global.ArangoClusterInfo.getCollectionInfo(dbName, '_from_' + collectionName);

    if (ci === undefined || typeof ci !== 'object') {
      throw "unable to determine shard list for '" + dbName + '/' + collectionName + "'";
    }

    for (let shard in ci.shards) {
      if (ci.shards.hasOwnProperty(shard)) {
        shards.push(shard);
      }
    }
  } else {
    raiseError(errors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.code,
      errors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.message);
  }
  return shards;
};
