/*jshint globalstrict:false, strict:false */
/*global assertEqual, assertTrue, assertNotEqual */
'use strict';

// //////////////////////////////////////////////////////////////////////////////
// / DISCLAIMER
// /
// / Copyright 2014-2024 ArangoDB GmbH, Cologne, Germany
// /
// / The Programs (which include both the software and documentation) contain
// / proprietary information of ArangoDB GmbH; they are provided under a license
// / agreement containing restrictions on use and disclosure and are also
// / protected by copyright, patent and other intellectual and industrial
// / property laws. Reverse engineering, disassembly or decompilation of the
// / Programs, except to the extent required to obtain interoperability with
// / other independently created software or as specified by law, is prohibited.
// /
// / It shall be the licensee's responsibility to take all appropriate fail-safe,
// / backup, redundancy, and other measures to ensure the safe use of
// / applications if the Programs are used for purposes such as nuclear,
// / aviation, mass transit, medical, or other inherently dangerous applications,
// / and ArangoDB GmbH disclaims liability for any damages caused by such use of
// / the Programs.
// /
// / This software is the confidential and proprietary information of ArangoDB
// / GmbH. You shall not disclose such confidential and proprietary information
// / and shall use it only in accordance with the terms of the license agreement
// / you entered into with ArangoDB GmbH.
// /
// / Copyright holder is ArangoDB GmbH, Cologne, Germany
// /
// / @author Roman Rabinovich
// //////////////////////////////////////////////////////////////////////////////

const enterpriseGenerator = function (vColl, label) {
    return {
        makeEdge: function (from, to) {
            return {
                _from: `${vColl}/${label}:${from}`,
                _to: `${vColl}/${label}:${to}`,
                vertex: `${label}:${from}:${label}`
            };
        }, makeVertex: function (name) {
            return {
                _key: `${label}:${name}`,
                label: `${label}`
            };
        },
    };
};

const enterpriseMakeEdgeBetweenVertices = function(vColl, from, fromLabel, to, toLabel) {
    return {
        _from: `${vColl}/${fromLabel}:${from}`,
        _to: `${vColl}/${toLabel}:${to}`,
        vertex: `${fromLabel}:${from}:${toLabel}`
    };
};

exports.enterpriseGenerator = enterpriseGenerator;
exports.enterpriseMakeEdgeBetweenVertices = enterpriseMakeEdgeBetweenVertices;
