'use strict';

// //////////////////////////////////////////////////////////////////////////////
// / DISCLAIMER
// /
// / Copyright 2014-2024 ArangoDB GmbH, Cologne, Germany
// /
// / The Programs (which include both the software and documentation) contain
// / proprietary information of ArangoDB GmbH; they are provided under a license
// / agreement containing restrictions on use and disclosure and are also
// / protected by copyright, patent and other intellectual and industrial
// / property laws. Reverse engineering, disassembly or decompilation of the
// / Programs, except to the extent required to obtain interoperability with
// / other independently created software or as specified by law, is prohibited.
// /
// / It shall be the licensee's responsibility to take all appropriate fail-safe,
// / backup, redundancy, and other measures to ensure the safe use of
// / applications if the Programs are used for purposes such as nuclear,
// / aviation, mass transit, medical, or other inherently dangerous applications,
// / and ArangoDB GmbH disclaims liability for any damages caused by such use of
// / the Programs.
// /
// / This software is the confidential and proprietary information of ArangoDB
// / GmbH. You shall not disclose such confidential and proprietary information
// / and shall use it only in accordance with the terms of the license agreement
// / you entered into with ArangoDB GmbH.
// /
// / Copyright holder is ArangoDB GmbH, Cologne, Germany
// /
/// @author Kaveh Vahedipour
/// @author Copyright 2021, ArangoDB Inc, Cologne, Germany
// //////////////////////////////////////////////////////////////////////////////

const base64 = require('internal').base64Encode;
const sign = require('internal').rsaprivsign;

// Public keys are in Enterprise/License/LicenseFeature.cpp
const pem2048 = `
-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEAwsFYaUhZJ3rmuUlBgW0aPHmetSAKS8E04kyP2R55v37BmiVE
uOB6ZlWysUeLlnk4Q+6ZTT9ROGW6XjijRWfLtIJBWTTl3oRqjrYX12A35uXnaxV7
60smmT3CW9RLH6vkG1Qep32tM48rGCPp8w5eZHhRlVgThz1rtPY6UyrzohSXpPX/
XoGXDj/wbyih91PMYSTe5UF+37wkMmLi8RAV5GBy24QSTu0BXq6MUeikdbzju/yv
ALsw2prAXGdtpmU0SR4cRZo9Y9lgmjwmni8Uek2es0ZTf0hva3YLvkFVK4XEA3pB
fSZbbuEQmkM81mLA3wZidS5j5Hnv1mX1QdamJwIDAQABAoIBAFpbZe+C14pPpRg1
+qRXwCJqss2KDfzTqPuNVfgAAbBs2NnxjI7R5zfvbrZ9YS/xEb/CxXFnfQFTgUIR
uP6Mh6A6BqOivTud5+pKZYlRZN5FsDaogxPJjCDw3GnKdwg8sdpUDtzanC8dr3rF
vtc7xWOLxx4o/PZz8rLEwo6vkNWTNQvGVts4ygaaRpDngwU+goK40c4yeFXAb17o
3liY9i2UhOWsdGSumltPVMr21s66XwD21EZYi/vJpZwHQfJzVPhcVYoiOS3PXYd8
EO3XjxTtb9vBe+9TeRegKY79b9Tq/jg64MTPKG/UyS+RCRRjab+w4gPhe3G+zMgD
LCAhliECgYEA4bRg2n2wBYWIrlHLS5+CRBTXEzeo1LQQlEsFrKscnROJnvjOTAhU
aM4jTRZw+wLV/2MO2WQh94GOq4hQaL+qV1CvPBwM7pWuBYTffxdn1J7CBFRr8CNo
uA0GQZo7F9+QX9UkQ4wTzOv0quAtOmW/MK05gT3a4y/tgzLE/WquRA8CgYEA3OV9
svv/2Qlg4d8Ciw8UMv/PmfHTJC66dHqZtANPGiBycps30eKMaatamVE56oAthB6M
5mPcnCv9Xo0oXQEWtO4vJEVwYnS3mEBnv2eWuqijJ2KhaIWFbFfGWQqwwkUDl/vP
cRIx6rZWuch7NIX8gSpAT+QYqCo/4z6loZ1rhGkCgYAR1EbmW5FhDkhaxNlTUvle
WWsX+IicrNC2diqvliC/g8CWTz80oF/Sm54MQ96O5Y10DCYrJA7O12wmvrDjZWiW
VyhQjkKzQh2qD/H7vySTlirrXqPcJ1/pUhYRbpaGb0GfYF3p/BHAWU9NhEHuYAU3
Wie1vuYgljOj7onDHv8/HwKBgGKsVOEN9nSh3tgmwUES5Ef/w2GWB2YjRYDgfyZN
UBlwow8UzPOBio1tUNQp14Ar76kT6IbF1vcgI1cIIR6ibN03hHFkX1ZrotNs+asj
f84zpGXkhgtlkXsbHmwJ/XlaUMekYT62DPw2pTjqGDcXHvsnv4CweF8uOEmvY1d1
NWD5AoGBAMczOOEDrXkpZ6lW3Yp9zLhQ0LuSCTlbaVg+kIxzRPYJI23Fm4befmMU
fa57BJtGubNayqUsRqnMnkd1XjCoAz/Vvm4RhJd5M9wBrl7fyjg2fCHqfAeGsm+a
VS3DDnrQEyvn9eJQaA6qZeeKGqSacKH4VWG8I3YfkoGRTvkT+Swy
-----END RSA PRIVATE KEY-----`;

const pem4096 = `
-----BEGIN RSA PRIVATE KEY-----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-----END RSA PRIVATE KEY-----`;

exports.makeLicense = function(validFor = 0, pem = pem2048, deploymentId = "", isManaged = false) {
  let grantJson = {
      version: 1,
      features: {expires: Math.round((new Date()).getTime() / 1000) + validFor},
      issuer: {name: "Kaveh Vahedipour", email: "no-reply@arangodb.com"},
      subject: {name: "Jane Doe", email: "jane@doe.com", instance: "production"},
      notBefore: "2021-11-01T00:00:00Z",
      notAfter: "2026-11-01T00:00:00Z"
    };
  if (deploymentId !== "") {
    grantJson.deploymentId = deploymentId;
  }
  if (isManaged) {
    grantJson.managed = true;
  }
  let grant = JSON.stringify(grantJson);
  let signature = sign(pem, grant);
  return base64(JSON.stringify({grant: base64(grant), signature}));
};
exports.pem2048 = pem2048;
exports.pem4096 = pem4096;
